#include "Bdef.h"

void vtcopy4(uplo, diag, m, n, A, lda, x)
char  uplo;
char  diag;
int  m;
int  n;
int  *A;
int  lda;
int  *x;
{
   int i, j, start, max;

   if (diag == 'u') start = 1;
   else start = 0;

   if (uplo == 'u')
   {
      if (m > n)
      {
         for (j=0; j<n; j++)  /* loop over columns */
         {
            max = m - n + j + 1 - start;
            for (i=0; i < max; i++) A[i] = x[i];
            x += max;
            A += lda;
         }
      }
      else /* if (uplo == 'u' && m <= n) */
      {

      /* --------------------------------------------- */
      /* copy m x m upper-triangular portion of matrix */
      /* --------------------------------------------- */
         for (j=0; j < m; j++) /* do 1st m columns */
         {
            max = j + 1 - start;
            for (i=0; i < max; i++) A[i] = x[i];
            x += max;
            A += lda;
         }
      /* -------------------------------------------- */
      /* copy m x (n-m) rectangular portion of matrix */
      /* -------------------------------------------- */
         max = n - m;
         for (j=0; j < max; j++) /* do last m-n columns */
         {
            for (i=0; i < m; i++) A[i] = x[i];
            x += m;
            A += lda;
         }
      }
   }
   else /* if (uplo == 'l') */
   {
      if (m > n)
      {
         A += start;
         lda++;
         for (j=0; j < n; j++)
         {
            max = m - j - start;
            for (i=0; i < max; i++) A[i] = x[i];
            x += max;
            A += lda;
         }
      }
      else /* if (uplo == 'l' && m <= n) */
      {

      /* -------------------------------- */
      /* copy m x (n-m) rectangular piece */
      /* -------------------------------- */
         max = n - m;
         for (j=0; j < max; j++)
         {
            for (i=0; i < m; i++) A[i] = x[i];
            x += m;
            A += lda;
         }
      /* --------------------------------- */
      /* copy m x m lower triangular piece */
      /* --------------------------------- */
         A += start;
         lda++;
         for (j=0; j < m; j++)
         {
            max = m - j - start;
            for (i=0; i < max; i++) A[i] = x[i];
            x += max;
            A += lda;
         }
      }
   }
}  /* end vtcopy4 */
