#include "Bdef.h"

void GetCombBuff(length, bp1, bp2)
int  length;
BLACBUFF  **bp1;
BLACBUFF  **bp2;
/*
 * Gets the buffer(s) for combines
 */
{
   char *getbuff();
   static BLACBUFF *Bp1=NULL, *Bp2;
   int i;
   extern int Np00;

/*
 * If first time in routine, malloc BLACBUFFs
 */
   if (Bp1 == NULL)
   {
      Bp1 = (BLACBUFF *) malloc(sizeof(*Bp1));
      Bp2 = (BLACBUFF *) malloc(sizeof(*Bp2));
      Bp1->Aops = (long *) malloc(2*Np00*sizeof(*Bp1->Aops));
      Bp2->Aops = &Bp1->Aops[Np00];
      Bp1->nAops = Bp2->nAops = 0;
   }

   if (length >= 0)
   {
/*
 *    If bp points to valid memory, only need one more buffer
 */
      if (*bp1)
      {
         Bp1->Buff = (char *) *bp1;
         Bp2->Buff = getbuff(length);
      }
      else
      {
         i = length % 8;
         if (i) i = length + 8 - i;
         else i = length;
         length += i;
         Bp1->Buff = getbuff(length);
         Bp2->Buff = &Bp1->Buff[i];
      }
      *bp1 = Bp1;
      *bp2 = Bp2;
   }
   else
   {
      free(Bp1->Aops);
      free(Bp1);
      free(Bp2);
      Bp1 = NULL;
   }
}
