/***************************************
					$Header$

					
***************************************/


#ifndef CAMM_SCALE_H
#define CAMM_SCALE_H    /*+ To stop multiple inclusions. +*/

#include "camm_util.h"

#define spf(a_,b_)  f(t0,a_,b_)

#ifdef SCPLX
#ifdef BETAX
#define SSREG      2
#define lbx        pls(4,ax,1) ps(0,1,1) pm(SSREG,1)
#define cxx        pm(1,3) ps(177,3,3) pa(3,2)
#define pcx        pc(2,3)
#else
#define lbx
#define cxx
#define pcx
#endif
#define lb         pls(0,ax,0) ps(0,0,0) lbx 
#define c(a_)      pl(a_ ## 0,si,2) pcx pm(0,2) cxx pu(2,a_ ## 0,si)
#define cp(a_,b_)  pl(a_ ## 0,si,2) pcx pm(0,2) spf(b_,si) cxx pu(2,a_ ## 0,si)
#endif

#ifdef SREAL
#define lb         pls(0,ax,0) ps(0,0,0)
#define c(a_)      pl(a_ ## 0,si,2) pm(0,2) pu(2,a_ ## 0,si)
#define cp(a_,b_)  pl(a_ ## 0,si,2) spf(b_,si) pm(0,2) pu(2,a_ ## 0,si)
#endif

#ifdef DREAL
#define lb        fl(0,ax)
#define c(a_)     fl(a_ ## 0,si) fm(1,0) fl(a_ ## 8,si) fm(2,0) fx1 \
                  fp(a_ ## 0,si) fp(a_ ## 8,si)
#define cp(a_,b_) fl(a_ ## 0,si) fm(1,0) fl(a_ ## 8,si) spf(b_,si) fm(2,0) fx1 \
                  fp(a_ ## 0,si) fp(a_ ## 8,si)
#endif

#ifdef DCPLX
#define lb        fl(0,ax) fl(8,ax)
#define c(a_)     fl(a_ ## 0,si) fl(a_ ## 8,si) fd(3) fm(2,0) fd(3) \
                  fm(2,0) fx(3) fm(4,0) fx(2) fm(5,0) fap(0,2) fx(2) fsp(2) fx1 \
                  fp(a_ ## 0,si) fp(a_ ## 8,si)
#define cp(a_,b_) fl(a_ ## 0,si) fl(a_ ## 8,si) fd(3) fm(2,0) fd(3) \
                  fm(2,0) fx(3) spf(b_,si) fm(4,0) fx(2) fm(5,0) fap(0,2) fx(2) \
                  fsp(2) fx1 fp(a_ ## 0,si) fp(a_ ## 8,si)
#endif

#define sbl4       cp(0x0,0x40)
#define sbl8       sbl4 c(0x1)
#define sbl16      sbl8 cp(0x2,0x60) c(0x3)

#define sinc16    a(0x40,si)
#define sinc8     a(0x20,si)
#define sinc4     a(0x10,si)

#define SCALE Mjoin(PREC,Mjoin(scale,BLC))

static void
SCALE(const TYPE *b,TYPE *c,int len) {

  const TYPE *ce=c+len;
#if defined(BETAX) && defined(SCPLX)
  const TYPE z[2]={{1.0,-1.0},{1.0,-1.0}};
#endif
  NO_INLINE;

#ifndef SREAL
  len+=len;
#endif
#ifdef DCPLX
  len+=len;
#endif


  ASM("movl %0,%%esi\n\t"

      spf(0x00,si)
      spf(0x20,si)

      "movl %1,%%eax\n\t"
      "movl %2,%%edi\n\t"

#if defined(BETAX) && defined(SCPLX)
      "movl %3,%%ebx\n\t"
      pl(0,bx,SSREG)
#endif

      lb

      lab(loop)

      test(-16,di)
      je(8)
      sub(16,di)
      align

      sbl16
      sinc16

      jmp(loop)
      align

      lab(8)

      test(8,di)
      je(4)

      sbl8
      sinc8

      lab(4)

      test(4,di)
      je(stop)

      sbl4
      sinc4

      lab(stop)

      "movl %%esi,%0\n\t"

      :"+m" (c): "m" (b), "m" (len)
#if defined(BETAX) && defined(SCPLX)
      ,"m" (z)
#endif
      : "si","ax","di");

#ifndef DCPLX
  for (;c<ce;c++) {
    TYPE t;

#if defined(SCPLX)
#if defined(BETAX)
    t.r=c->r;
    c->r=c->r*b->r-c->i*b->i;
    c->i=c->i*b->r+t.r*b->i;
#else
    c->r*=b->r;
    c->i*=b->r;
#endif
#else
    *c*=*b;
#endif

  }
#endif

}
#endif /* CAMM_SCALE_H */
